from random import choices, randint

from cube import POSSIBLE_MOVES, Cube


def round_func(key, _input, no_confusion=False):
    assert len(key) == 16
    assert len(_input) == 54
    assert type(_input) is bytes

    # build the rotation key
    rot_key = [POSSIBLE_MOVES[b % len(POSSIBLE_MOVES)] for b in key]

    # populate the cube
    cube = Cube(list(_input))

    # do the rotations
    [cube.do_rotation(m) for m in rot_key]

    # xor the state with the key (wrap around)

    if no_confusion:
        return cube.get_state()

    return [x ^ key[i % len(key)] for i, x in enumerate(cube.get_state())]
